/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	AlchemyLab
**
** DESCRIPTION:	Alchemy lab construction puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ALCHEMYLAB_H
#define ALCHEMYLAB_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const char AlchemyLab_c_sImageName[] = "AlchemyLab";
const int AlchemyLab_c_iNumPieces = 5;
const int AlchemyLab_c_iNumPossiblePositions = 16;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAlchemyLab : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class enumerations
	enum EState
	{
		eState_Scattered = 0,
		eState_Carried,
		eState_Collected,

		eState_NumberOf
	};

	//class structures
	struct SSaveState
	{
		EState			m_eState[AlchemyLab_c_iNumPieces];
		ldwPoint		m_sPos[AlchemyLab_c_iNumPieces];
	};

	struct SPiece
	{
		ldwImage *		m_pImage;

		EState			m_eState;
		ldwPoint		m_sPos;
	};

	//class data
	SPiece		m_sPiece[AlchemyLab_c_iNumPieces];

	//class methods
	//setup
	public:		CAlchemyLab(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool IsRepaired() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAlchemyLab		AlchemyLab;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/